clear all
close all
fclose('all');
clc

font=16;
num=40;
x=0:9:360;
init=zeros(1,num+1);
tickx=0:45:360;

Vh=init;
Ve=init;
V12=init;
V21=init;

figure('Renderer', 'painters', 'Position', [10 10 1200 400])

%S2
i=1;
for txt=["Gas", "Hexane", "ACN"]
    
    %%
    for j=1:num
        filename = sprintf("C:/Users/Gebruiker/Desktop/Internship/plots/CT-data-compact/CT-data-compact/%s/angle(%d)/slurm.out",txt,j);
        fid=fopen(filename);
        C = textscan(fid, '%s');
        C=C{1};
        Index = find(contains(C,'transfer'));
        
        Vh(j)=str2double(C{Index(3)+1});
        Ve(j)=str2double(C{Index(4)+1});
        
        Index = find(contains(C,'charge_recombination'));
        
        V12(j)=str2double(C{Index(1)+2});
        V21(j)=str2double(C{Index(2)+2});
        fclose('all');
        
    end
    
    
    if  txt=="Gas"
        JG=Vh;
    elseif txt=="Hexane"
        JH=Vh;
    else
        JA=Vh;
    end
    
    Ve(end)=Ve(1);
    Vh(end)=Vh(1);
    V12(end)=V12(1);
    V21(end)=V21(1);
    
    %%
    subplot(1,3,i)
    CT_plot(x,8065.6*abs(Ve),font','','-d')
    hold on
    CT_plot(x,8065.6*abs(Vh),font','','-d')
    CT_plot(x,8065.6*abs(V12),font','','-d')
    CT_plot(x,8065.6*abs(V21),font','','-d')
    
    xticks(tickx)
    ylabel('$|V|\:(cm^{-1})$','interpreter','latex')
    xlim([40 330])
    tickx=0:90:360;
    xticks(tickx)
    legend('$V_{e}$','$V_{h}$','$V_{12}$','$V_{21}$','interpreter','latex')
    if txt=="Hexane"
        txt="NHX";
    end
    title('$'+txt+'$','interpreter','latex')
    i=i+1
end


figure
CT_plot(x,8065.6*abs(JG),font,'','-s')
hold on
CT_plot(x,8065.6*abs(JA),font,'','-d')
CT_plot(x,8065.6*abs(JH),font,'','-h')

xline(65.7)
xline(70.4)
xline(67.1)

ylabel('$|V_{CT}|\:(cm^{-1})$','interpreter','latex')
xlim([50 310])
tickx=0:45:360;
xticks(tickx)
legend('$Gas$','$ACN$','$NHX$','interpreter','latex')